/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class RcsProperties
extends HashMap {
    private static final String ELEMENT_PROPERTIES = "properties";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_KEY = "key";
    private static final String ELEMENT_VALUE = "value";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String KEY_PATTERN = "[^A-Za-z0-9_\\-\\ ]";
    private static final String BREAK_PATTERN = "\\s+\\\\\\s*\\n\\s+";

    public RcsProperties() {
    }

    public RcsProperties(Reader reader) throws IOException, SAXException {
        this();
        this.readXmlData(reader);
    }

    public RcsProperties(RcsProperties properties) {
        super(properties);
    }

    public String put(String key, String value) {
        String myKey = key == null ? "" : key.replaceAll(KEY_PATTERN, "");
        String myValue = value == null ? "" : value.replaceAll(BREAK_PATTERN, " ");
        return super.put(myKey, myValue);
    }

    public String get(String key) {
        return (String)super.get(key.replaceAll(KEY_PATTERN, ""));
    }

    public String remove(String key) {
        return (String)super.remove(key);
    }

    public void readXmlData(Reader reader) throws IOException, SAXException {
        this.clear();
        new XmlHandler().parseXml(reader);
    }

    public void writeXmlData(Writer writer) throws IOException {
        String xml = "";
        xml = xml + this.toXml();
        writer.write(xml);
        writer.close();
    }

    public String toXml() {
        String s = "";
        s = s + "<properties>\n";
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = this.get(key);
            s = s + "    <property key=\"" + key + "\">" + value + "</" + ELEMENT_PROPERTY + ">\n";
        }
        s = s + "</property>\n";
        return s;
    }

    class XmlHandler
    extends DefaultHandler {
        private XMLReader xmlReader = new SAXParser();
        private StringBuffer chars = new StringBuffer();
        private String key;
        private String value;

        public XmlHandler() {
            this.xmlReader = new SAXParser();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
            this.chars = new StringBuffer();
        }

        public void parseXml(Reader reader) throws IOException, SAXException {
            this.xmlReader.parse(new InputSource(reader));
        }

        public void startDocument() throws SAXException {
            this.chars.setLength(0);
        }

        public void endDocument() throws SAXException {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.chars.setLength(0);
            try {
                if (localName.equals(RcsProperties.ELEMENT_PROPERTIES)) return;
                if (localName.equals(RcsProperties.ELEMENT_PROPERTY)) {
                    this.key = attributes.getValue("key");
                    this.value = attributes.getValue("value");
                    return;
                }
                if (!localName.equals("key") && !localName.equals("value")) return;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (!localName.equals(RcsProperties.ELEMENT_PROPERTIES)) {
                    if (localName.equals(RcsProperties.ELEMENT_PROPERTY)) {
                        if (this.value == null) {
                            this.value = this.chars.toString();
                        }
                        if (RcsProperties.this.get(this.key) == null) {
                            RcsProperties.this.put(this.key, this.value);
                        } else {
                            RcsProperties.this.put(this.key, RcsProperties.this.get(this.key) + " " + this.value);
                        }
                    } else if (localName.equals("key")) {
                        this.key = this.chars.toString();
                    } else if (localName.equals("value")) {
                        this.value = this.chars.toString();
                    }
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }
    }
}

